// $Id: CWindowDragTab.cpp,v 1.6 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CWindowDragTab.hpp"
using Exponent::GUI::Controls::CWindowDragTab;
#include <Exceptions/CException.hpp>
using Exponent::Exceptions::CException;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CWindowDragTab, CControl);

//	===========================================================================
CWindowDragTab::CWindowDragTab(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener) 
			  : CControl(root, uniqueId, area, listener)
			  , m_mouseIsDown(false)
			  , m_dragOffset(0, 0)
{
	EXPONENT_CLASS_CONSTRUCTION(CWindowDragTab);
}

//	===========================================================================
CWindowDragTab::~CWindowDragTab()
{
	EXPONENT_CLASS_DESTRUCTION(CWindowDragTab);
}

//	===========================================================================
void CWindowDragTab::handleLeftButtonDown(CMouseEvent &event)
{
	m_mouseIsDown = true;
	m_dragOffset  = event.getMousePosition();
	m_rootControl->lockControl(this);
}

//	===========================================================================
void CWindowDragTab::handleLeftButtonUp(CMouseEvent &event)
{
	m_mouseIsDown = false;
	m_dragOffset  = CPoint(0, 0);
	m_rootControl->unlockControl();
}

//	===========================================================================
void CWindowDragTab::handleMouseMovement(CMouseEvent &event)
{
	if (m_mouseIsDown)
	{
		// Get the root window that we are going to move
		IWindow *rootWindow = m_rootControl->getParentWindow();

		// Check that we got a valid root window
		if (rootWindow == NULL)
		{
			throw CException("Root Window is NULL", "CWindowDragTab::handleMouseMovement(CMouseEvent &)");
		}

		// Get the global co-ordinates of the mouse
		CPoint mousePosition;
		CWindowTools::getMousePosition(mousePosition);
		mousePosition.offset(-m_dragOffset.getXPosition(), -m_dragOffset.getYPosition());
		rootWindow->setWindowPosition(mousePosition);
	}
}

//	===========================================================================
void CWindowDragTab::drawControl(CGraphics &graphics)
{
	// First check if we can allow the standard handler to draw the disabled control
	if (!this->drawEnabledControl(graphics))
	{
		return;
	}

	// Now we can draw
	this->drawPrimaryImage(graphics, m_doDefaultDrawing);
}